--made by silence:

local UIS, Players, TweenService, RunService = game:GetService("UserInputService"), game:GetService("Players"), game:GetService("TweenService"), game:GetService("RunService")
local player, originalWalkSpeed, originalJumpPower = Players.LocalPlayer, 16, 50
local toggledWalkSpeed, toggledJumpPower = 17, 51
local isWalkSpeedToggled, killScriptDisabled, fpsBoostTriggered = false, false, false

local screenGui = Instance.new("ScreenGui", game.CoreGui)
screenGui.Name = "StatusGui"
local statusLabel = Instance.new("TextLabel", screenGui)
statusLabel.Size, statusLabel.Position = UDim2.new(0.3, 0, 0.05, 0), UDim2.new(0.35, 0, 0.95, 0)
statusLabel.Font, statusLabel.TextSize, statusLabel.TextColor3, statusLabel.BackgroundTransparency = Enum.Font.Roboto, 18, Color3.new(1, 1, 1), 1
statusLabel.Text = "..."

local function updateStatusLabel(message)
    statusLabel.Text = message
    TweenService:Create(statusLabel, TweenInfo.new(0.15, Enum.EasingStyle.Quad, Enum.EasingDirection.Out, 0, true), {Size = UDim2.new(0.32, 0, 0.055, 0)}):Play()
    delay(4, function() if statusLabel.Text == message then statusLabel.Text = "..." end end)
end

local function checkGame()
    local placeId = game.PlaceId
    local msg = "Player is not on Tower of Hell or Pro Tower of Hell"
    if placeId == 1962086868 then msg = "Player is on Tower of Hell" end
    if placeId == 3582763398 then msg = "Player is on Pro Tower of Hell" end
    updateStatusLabel(msg)
    delay(5, function()
        updateStatusLabel("Ctrl + E = God Mode, Ctrl + R = Slightly Increase WalkSpeed & JumpPower, Ctrl + F = FPS Boost")
    end)
end

local function toggleKillScript()
    local character = player.Character
    if character then
        local killScript = character:FindFirstChild("KillScript")
        if killScript then
            killScriptDisabled = not killScriptDisabled
            killScript.Disabled = killScriptDisabled
            updateStatusLabel("KillScript.Disabled is now set to " .. tostring(killScriptDisabled))
        else
            updateStatusLabel("KillScript not found in character")
        end
    else
        updateStatusLabel("Character not found")
    end
end

local function toggleWalkSpeedAndJumpPower()
    local character, humanoid = player.Character, player.Character and player.Character:FindFirstChildOfClass("Humanoid")
    if humanoid then
        isWalkSpeedToggled = not isWalkSpeedToggled
        humanoid.WalkSpeed, humanoid.JumpPower = isWalkSpeedToggled and toggledWalkSpeed or originalWalkSpeed, isWalkSpeedToggled and toggledJumpPower or originalJumpPower
        updateStatusLabel("WalkSpeed set to " .. humanoid.WalkSpeed .. " and JumpPower set to " .. humanoid.JumpPower)
    else
        updateStatusLabel(character and "Humanoid not found in character" or "Character not found")
    end
end

local function onInputBegan(input, gameProcessedEvent)
    if gameProcessedEvent then return end
    local isCtrlDown = UIS:IsKeyDown(Enum.KeyCode.LeftControl)
    if input.KeyCode == Enum.KeyCode.E and isCtrlDown then
        toggleKillScript()
    elseif input.KeyCode == Enum.KeyCode.R and isCtrlDown then
        toggleWalkSpeedAndJumpPower()
    elseif input.KeyCode == Enum.KeyCode.F and isCtrlDown then
        if fpsBoostTriggered then
            updateStatusLabel("You can't use FPS boost, it's already toggled on")
        else
            fpsBoostTriggered = true
            updateStatusLabel("FPS boost triggered! Have fun lol")
            -- FPS Booster Script
            if not _G.Ignore then _G.Ignore, _G.WaitPerAmount, _G.SendNotifications, _G.ConsoleLogs = {}, 500, false, false end
            if not game:IsLoaded() then repeat task.wait() until game:IsLoaded() end
            if not _G.Settings then
                _G.Settings = {
                    Players = {["Ignore Me"] = true, ["Ignore Others"] = true, ["Ignore Tools"] = true},
                    Meshes = {NoMesh = false, NoTexture = false, Destroy = false},
                    Images = {Invisible = true, Destroy = false},
                    Explosions = {Smaller = true, Invisible = false, Destroy = false},
                    Particles = {Invisible = true, Destroy = false},
                    TextLabels = {LowerQuality = false, Invisible = false, Destroy = false},
                    MeshParts = {LowerQuality = true, Invisible = false, NoTexture = false, NoMesh = false, Destroy = false},
                    Other = {["FPS Cap"] = 120, ["No Camera Effects"] = true, ["No Clothes"] = true, ["Low Water Graphics"] = true, ["No Shadows"] = true, ["Low Rendering"] = true, ["Low Quality Parts"] = true, ["Low Quality Models"] = true, ["Reset Materials"] = true, ["Lower Quality MeshParts"] = true}
                }
            end

            local Players, Lighting, MaterialService = game:GetService("Players"), game:GetService("Lighting"), game:GetService("MaterialService")
            local ME, CanBeEnabled = Players.LocalPlayer, {"ParticleEmitter", "Trail", "Smoke", "Fire", "Sparkles"}

            local function PartOfCharacter(Instance)
                for _, v in pairs(Players:GetPlayers()) do
                    if v ~= ME and v.Character and Instance:IsDescendantOf(v.Character) then return true end
                end
                return false
            end

            local function DescendantOfIgnore(Instance)
                for _, v in pairs(_G.Ignore) do
                    if Instance:IsDescendantOf(v) then return true end
                end
                return false
            end

            local function CheckIfBad(Instance)
                if not Instance:IsDescendantOf(Players) and (_G.Settings.Players["Ignore Others"] and not PartOfCharacter(Instance) or not _G.Settings.Players["Ignore Others"]) and (_G.Settings.Players["Ignore Me"] and ME.Character and not Instance:IsDescendantOf(ME.Character) or not _G.Settings.Players["Ignore Me"]) and (_G.Settings.Players["Ignore Tools"] and not Instance:IsA("BackpackItem") and not Instance:FindFirstAncestorWhichIsA("BackpackItem") or not _G.Settings.Players["Ignore Tools"]) and (_G.Ignore and not table.find(_G.Ignore, Instance) and not DescendantOfIgnore(Instance) or (not _G.Ignore or type(_G.Ignore) ~= "table" or #_G.Ignore <= 0)) then
                    if Instance:IsA("DataModelMesh") then
                        if _G.Settings.Meshes.NoMesh and Instance:IsA("SpecialMesh") then Instance.MeshId = "" end
                        if _G.Settings.Meshes.NoTexture and Instance:IsA("SpecialMesh") then Instance.TextureId = "" end
                        if _G.Settings.Meshes.Destroy or _G.Settings["No Meshes"] then Instance:Destroy() end
                    elseif Instance:IsA("FaceInstance") then
                        if _G.Settings.Images.Invisible then Instance.Transparency = 1; Instance.Shiny = 1 end
                        if _G.Settings.Images.Destroy then Instance:Destroy() end
                    elseif Instance:IsA("ShirtGraphic") then
                        if _G.Settings.Images.Invisible then Instance.Graphic = "" end
                        if _G.Settings.Images.Destroy then Instance:Destroy() end
                    elseif table.find(CanBeEnabled, Instance.ClassName) then
                        if _G.Settings["Invisible Particles"] or _G.Settings["No Particles"] or (_G.Settings.Other and _G.Settings.Other["Invisible Particles"]) or (_G.Settings.Particles and _G.Settings.Particles.Invisible) then Instance.Enabled = false end
                        if (_G.Settings.Other and _G.Settings.Other["No Particles"]) or (_G.Settings.Particles and _G.Settings.Particles.Destroy) then Instance:Destroy() end
                    elseif Instance:IsA("PostEffect") and (_G.Settings["No Camera Effects"] or (_G.Settings.Other and _G.Settings.Other["No Camera Effects"])) then Instance.Enabled = false
                    elseif Instance:IsA("Explosion") then
                        if _G.Settings["Smaller Explosions"] or (_G.Settings.Other and _G.Settings.Other["Smaller Explosions"]) or (_G.Settings.Explosions and _G.Settings.Explosions.Smaller) then Instance.BlastPressure = 1; Instance.BlastRadius = 1 end
                        if _G.Settings["Invisible Explosions"] or (_G.Settings.Other and _G.Settings.Other["Invisible Explosions"]) or (_G.Settings.Explosions and _G.Settings.Explosions.Invisible) then Instance.BlastPressure = 1; Instance.BlastRadius = 1; Instance.Visible = false end
                        if _G.Settings["No Explosions"] or (_G.Settings.Other and _G.Settings.Other["No Explosions"]) or (_G.Settings.Explosions and _G.Settings.Explosions.Destroy) then Instance:Destroy() end
                    elseif Instance:IsA("Clothing") or Instance:IsA("SurfaceAppearance") or Instance:IsA("BaseWrap") then
                        if _G.Settings["No Clothes"] or (_G.Settings.Other and _G.Settings.Other["No Clothes"]) then Instance:Destroy() end
                    elseif Instance:IsA("BasePart") and not Instance:IsA("MeshPart") then
                        if _G.Settings["Low Quality Parts"] or (_G.Settings.Other and _G.Settings.Other["Low Quality Parts"]) then
                            if Instance.Material ~= Enum.Material.Neon then
                                Instance.Material = Enum.Material.Plastic
                                Instance.Reflectance = 0
                            end
                        end
                    elseif Instance:IsA("TextLabel") and Instance:IsDescendantOf(workspace) then
                        if _G.Settings["Lower Quality TextLabels"] or (_G.Settings.Other and _G.Settings.Other["Lower Quality TextLabels"]) or (_G.Settings.TextLabels and _G.Settings.TextLabels.LowerQuality) then Instance.Font = Enum.Font.SourceSans; Instance.TextScaled = false; Instance.RichText = false; Instance.TextSize = 14 end
                        if _G.Settings["Invisible TextLabels"] or (_G.Settings.Other and _G.Settings.Other["Invisible TextLabels"]) or (_G.Settings.TextLabels and _G.Settings.TextLabels.Invisible) then Instance.Visible = false end
                        if _G.Settings["No TextLabels"] or (_G.Settings.Other and _G.Settings.Other["No TextLabels"]) or (_G.Settings.TextLabels and _G.Settings.TextLabels.Destroy) then Instance:Destroy() end
                    elseif Instance:IsA("Model") then
                        if _G.Settings["Low Quality Models"] or (_G.Settings.Other and _G.Settings.Other["Low Quality Models"]) then Instance.LevelOfDetail = 1 end
                    elseif Instance:IsA("MeshPart") then
                        if _G.Settings["Low Quality MeshParts"] or (_G.Settings.Other and _G.Settings.Other["Low Quality MeshParts"]) or (_G.Settings.MeshParts and _G.Settings.MeshParts.LowerQuality) then Instance.RenderFidelity = 2; Instance.Reflectance = 0; Instance.Material = Enum.Material.Plastic end
                        if _G.Settings["Invisible MeshParts"] or (_G.Settings.Other and _G.Settings.Other["Invisible MeshParts"]) or (_G.Settings.MeshParts and _G.Settings.MeshParts.Invisible) then Instance.Transparency = 1; Instance.RenderFidelity = 2; Instance.Reflectance = 0; Instance.Material = Enum.Material.Plastic end
                        if _G.Settings.MeshParts and _G.Settings.MeshParts.NoTexture then Instance.TextureID = "" end
                        if _G.Settings.MeshParts and _G.Settings.MeshParts.NoMesh then Instance.MeshId = "" end
                        if _G.Settings["No MeshParts"] or (_G.Settings.Other and _G.Settings.Other["No MeshParts"]) or (_G.Settings.MeshParts and _G.Settings.MeshParts.Destroy) then Instance:Destroy() end
                    end
                end
            end

            if setfpscap then setfpscap(120) end

            game.DescendantAdded:Connect(function(value) wait(_G.LoadedWait or 1); CheckIfBad(value) end)

            local Descendants = game:GetDescendants()
            for i, v in pairs(Descendants) do CheckIfBad(v); if i % (_G.WaitPerAmount or 500) == 0 then task.wait() end end
        end
    end
end

local function onCharacterAdded(character)
    character:WaitForChild("Humanoid").Died:Connect(function()
        updateStatusLabel("Player has resetted, WalkSpeed is now back to " .. originalWalkSpeed .. " and JumpPower to " .. originalJumpPower)
        local newHumanoid = player.Character:WaitForChild("Humanoid")
        newHumanoid.WalkSpeed, newHumanoid.JumpPower = originalWalkSpeed, originalJumpPower
        isWalkSpeedToggled = false
        wait(5)
        updateStatusLabel("Character respawned. KillScript.Disabled is " .. tostring(killScriptDisabled))
    end)
end

UIS.InputBegan:Connect(onInputBegan)
player.CharacterAdded:Connect(onCharacterAdded)
checkGame()
if player.Character then onCharacterAdded(player.Character) end

local notified = false
RunService.RenderStepped:Connect(function()
    if not notified then
        checkGame()
        notified = true
    end
end)
